 ; Ŀ
 ;   Stoat - write all text and attribute strings to a file, one string    
 ;   per line, add the filename every 20 lines.                            
 ;   Copyright 1991, 1995, 2003, 2009 by Rocket Software Ltd.              
 ;   There is no red dishwashing liquid.                                   
 ; 

 ; Ŀ
 ;   Riot - write text to a file if it isn't an empty string.              
 ; 
 (DEFUN RIOT (txt filnam /)
  (while (and (> (strlen txt) 0) (= (substr txt 1 1) " "))
         (setq txt (substr txt 2)))
  (if (not (member txt '("" " ")))
      (progn
           (write-line txt filnam)
           (if (> (setq steps (1+ steps)) 20)
               (progn
                    (setq steps 1)
                    (write-line namstr filnam)))))
 (princ))
 ; Ŀ
 ;   Riot end.                                                             
 ; 

 ; Ŀ
 ;   Fruge - see if a file name exists and decide what to do with it.      
 ; 
 (DEFUN FRUGE (/ filp filnam quipt subfil)
  (setq filp (getvar "dwgname"))
  (if (= (substr (strcase filp) (- (strlen filp) 3)) ".DWG")
      (setq filp (substr filp 1 (- (strlen filp) 4))))
  (setq filp (strcat filp ".lis"))
  (setq filnam (getstring (strcat "\nFilename <" filp ">: ")))
  (if (= filnam "") (setq filnam filp))
  (if (findfile filnam)
      (progn
           (initget 0 "Overwrite Append Quit")
           (setq quipt (getkword (strcat "That file already exists."
                                         "  Overwrite, Append, or <Quit>? ")))
           (if (null quipt) (setq quipt "Quit"))))
  (cond ((or (null quipt) (= quipt "Append"))
         (setq subfil (open filnam "a"))
         (if (null subfil)
             (write-line "Unable to open that file")))
        ((= quipt "Overwrite")
         (setq subfil (open filnam "w"))
         (close subfil)
         (setq subfil (open filnam "a"))
         (if (null subfil)
             (write-line "Unable to open that file")))
        ((= quipt "Quit")
         (setq subfil ())))
 subfil)
 ; Ŀ
 ;   Fruge end.                                                            
 ; 

 ; Ŀ
 ;   Stoat - the predator.                                                 
 ; 
 (DEFUN C:STOAT (/ getinv filnam hi ss lenx numtx so txt txa num invis len
                    dnam prefx namstr steps sub entt visatt enam esub entt)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Initialise the repeated file name inserter.                           
 ; 
  (setq steps 1)
 ; Ŀ
 ;   Get various preferences - what to include and a filename.             
 ;   (Unless we are in the middle of a script.)                            
 ; 
  (if (/= 4 (logand 4 (getvar "cmdactive")))
      (progn
           (initget 0 "Yes No")
           (setq getinv (getkword "Include invisible attributes? <No>: "))
           (if (= getinv "Yes")
               (setq getinv T)
               (setq getinv ()))
           (setq filnam (fruge)))
      (progn
           (setq getinv ())
           (setq filnam (open "alltext.txt" "a"))))
 ; Ŀ
 ;   Write the drawing file name to the text file.                         
 ; 
  (setq dnam (getvar "dwgname"))
  (setq prefx (getvar "dwgprefix"))
  (riot (strcat "***** Start " dnam " *****  (" prefx dnam ")") filnam)
  (setq namstr (strcat "***** " dnam " *****  (" prefx dnam ")"))
 ; Ŀ
 ;   Get a selection set of all text entities.                             
 ; 
  (setq ss (ssget "X" '((0 . "TEXT"))))
 ; Ŀ
 ;   Make length counter half-string.                                      
 ; 
  (if ss (setq lenx (strcat "/" (itoa (sslength ss))))
         (prompt "No text found."))
 ; Ŀ
 ;   While there are text entities in the selection set.                   
 ; 
  (setq numtx 0)
  (while (and ss (setq so (ssname ss numtx)))
         (setq txt (cdr (assoc 1 (setq txa (entget so)))))
         (riot txt filnam)
         (grtext -2 (strcat (itoa (setq numtx (1+ numtx))) lenx)))
 ; Ŀ
 ;   Get a selection set of all mtext entities.                            
 ; 
  (setq ss (ssget "X" '((0 . "mtext"))))
 ; Ŀ
 ;   Make length counter half-string.                                      
 ; 
  (if ss (setq lenx (strcat "/" (itoa (sslength ss))))
         (prompt "No mtext found."))
 ; Ŀ
 ;   While there are mtext entities in the selection set.                  
 ; 
  (setq num 0)
  (while (and ss (setq so (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget so))
         (while (setq sub (car entt))
                (setq entt (cdr entt))
                (if (member (car sub) '(1 3))
                    (riot (cdr sub) filnam)))
         (grtext -2 (strcat (itoa (setq numtx (1+ numtx))) lenx)))
 ; Ŀ
 ;   Now repeat for attributes.                                            
 ; 
  (setq num 0)    ; position in ss
  (setq invis 0)  ; invisible attribute counter
 ; Ŀ
 ;   Get selection set of blocks with attributes.                          
 ; 
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
 ; Ŀ
 ;   Make length counter half-string.                                      
 ; 
  (if ss
     (setq len (strcat "/" (itoa (sslength ss))))
     (prompt "No attributed blocks found."))
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (setq visatt 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                (setq txt (cdr (assoc 1 entt)))
                (if (= 1 (logand 1 (cdr (assoc 70 entt))))  ; invisible?
                    (progn
                         (setq invis (1+ invis))
                         (if getinv (riot txt filnam)))
                    (progn
                         (setq visatt (1+ visatt))
                         (riot txt filnam)))
                (setq esub (entnext esub))))
 ; Ŀ
 ;   Add a couple of empty lines, close the output file.                   
 ; 
  (riot (strcat "***** End of " (getvar "dwgname") " *****") filnam)
  (riot "\n\n\n\n\n" filnam)
  (close filnam)
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (prompt (strcat "\nText: " (itoa numtx)
                  "; Attributes - Visible: " (itoa visatt)
                  ", Invisible: " (itoa invis)))
 (princ))